<?PHP
/*
 * WaterMark Plugin!
 * Author: flash.tato
 * WebSite: http://www.tatodev.host22.com
 */
 
if(THIS_SCRIPT == "editpost.php" || THIS_SCRIPT == "attachment.php" || THIS_SCRIPT == "newthread.php" || THIS_SCRIPT == "newreply.php" || defined('IN_ADMIN'))
	$GLOBALS['watermark'] = new Watermark();

function watermark_info()
{
	return array(
		"name"			=> "هاك الصورة المائية علي الصور",
		"description"	=> "اضافة صورة مائية علي الصورة بالمرفقات",
		"website"		=> "",
		"author"		=> "flash.tato",
		"authorsite"	=> "http://www.tatodev.host22.com/",
		"version"		=> "0.3.1",
		"compatibility" => "16*",
		"guid"			=> "5c8a159954a67e55585c8e043059e928"
	);
}

function watermark_is_installed()
{
	global $db;
	$query = $db->simple_select("settinggroups", "gid", "name='watermark'");
	$second_query = $db->simple_select("settings", "name", "name='watermark_file'");
	return $db->num_rows($query) && $db->num_rows($second_query) && $db->field_exists("watermark", "usergroups") && $db->field_exists("watermark", "attachments");
}

function watermark_install()
{
	global $db;
	$db->write_query("ALTER TABLE  `". TABLE_PREFIX  ."usergroups` ADD  `watermark` INT( 1 ) NOT NULL DEFAULT  '0'");
	$db->write_query("ALTER TABLE  `". TABLE_PREFIX  ."attachments` ADD  `watermark` INT( 1 ) NOT NULL DEFAULT  '0'");
	$template = array('title' => "post_attachments_attachment_mod_watermark", 'sid' => "-1", 'dateline' => TIME_NOW, 
	'template' => $db->escape_string('<input type="submit" class="button" name="watermarkattach" value="{$lang->watermark_apply}" onclick="return Post.attachmentAction({$attachment[\'aid\']},\'watermark\');" />'));
	$db->insert_query("templates", $template);
	$template = array('title' => "post_attachments_attachment_mod_unwatermark", 'sid' => "-1", 'dateline' => TIME_NOW, 
	'template' => $db->escape_string('<input type="submit" class="button" name="watermarkattach" value="{$lang->watermark_not_apply}" onclick="return Post.attachmentAction({$attachment[\'aid\']},\'unwatermark\');" />'));
	$db->insert_query("templates", $template);
	$settings_group = array(
		"gid"            => "NULL",
		"title"          => "هاك الصورة المائية علي الصور",
		"name"           => "watermark",
		"description"    => "اعدادات الهاك",
		"disporder"      => '10',
		"isdefault"      => "0"
	);
	$db->insert_query("settinggroups", $settings_group);
	$gid = $db->insert_id();
	$setting_1 = array(
		"sid"            => "NULL",
		"name"           => "watermark_file",
		"title"          => "الصورة المائية",
		"description"    => "ضع رابط الصورة المائية التي سيتم وضعها علي الصور المرفقة يفضل يكون صيغة الصورة PNG GIF",
		"optionscode"    => "text",
		"value"          => '',
		"disporder"      => '1',
		"gid"            => $gid
	);
	$db->insert_query("settings", $setting_1);
	rebuild_settings();
}

function watermark_uninstall()
{
	global $db;
	$db->write_query("ALTER TABLE  `". TABLE_PREFIX  ."attachments` DROP  `watermark`");
	$db->write_query("ALTER TABLE  `". TABLE_PREFIX  ."usergroups` DROP  `watermark`");
	$db->delete_query("templates", "title IN ('post_attachments_attachment_mod_watermark', 'post_attachments_attachment_mod_unwatermark')");
	$db->delete_query("settings", "name='watermark_file'");
	$db->delete_query("settinggroups", "name='watermark'");
	rebuild_settings();
}

function get_attachment($aid)
{
	global $db;
	if($aid)
	{
		$query = $db->simple_select("attachments", "*", "aid='".intval($aid)."'");
		$attachment = $db->fetch_array($query);
		if($attachment)
			return $attachment;
	}
	return null;
}

class Watermark
{

	private $cache_dir;
	
	private $wpic;

	function __construct()
	{
		global $mybb;
		$this->wpic = str_ireplace("_root_", MYBB_ROOT, $mybb->settings['watermark_file']);
		$this->cache_dir = MYBB_ROOT . "uploads/watermark_cache/";
	}
	
	function OpenImage($file, $format = "")
	{
		if(!$format)
			$format = get_extension($file);
		switch($format)
		{
			case "gif":
				return @imagecreatefromgif($file);
			case "png":
				return @imagecreatefrompng($file);
			case "jpg":
			case "jpeg":
			case "jpe":
				return @imagecreatefromjpeg($file);
		}
		return null;
	}
	
	function GetImageOutput($image, $format = "")
	{
		ob_start();
		switch($format)
		{
			case "gif":
				imagegif($image);
				break;
			case "png":
				imagepng($image);
				break;
			case "jpg":
			case "jpeg":
			case "jpe":
				imagejpeg($image);
				break;
		}
		$content = ob_get_contents();
		ob_end_clean();
		return $content;
	}
	
	function Apply($im, $path)
	{
		$watermark = $this->OpenImage($this->wpic);
		if(!$im || !$watermark)
			return;
		$w_w = imagesx($watermark);
		$w_h = imagesy($watermark);
		$size = getimagesize($path);
		$d_x = $size[0] - $w_w - 10;
		$d_y = $size[1] - $w_h - 10;
		$tempimage = imagecreatetruecolor($size[0], $size[1]);
		imagecopy($tempimage, $im, 0, 0, 0, 0, $size[0], $size[1]);
		$im = $tempimage;
		imagesavealpha($im, true);
		imagecopy($im, $watermark, $d_x, $d_y, 0, 0, $w_w, $w_h);
		imagedestroy($watermark);
		return $im;
	}
	
	function IsAppliedTo($attachment)
	{
		global $db;
		$query = $db->simple_select("attachments", "watermark", "aid='{$attachment['aid']}'");
		return (bool) intval($db->fetch_field($query, "watermark"));
	}
	
	function GetCacheFileName($attachment)
	{
		return $this->cache_dir . str_replace("/", "__", $attachment['attachname']);
	}
	
	function IsCached($attachment)
	{
		return file_exists($this->GetCacheFileName($attachment));
	}
	
	function CreateCacheEntry($attachment)
	{
		global $mybb;
		$path = $mybb->settings['uploadspath']."/".$attachment['attachname'];
		$ext = get_extension($attachment['filename']);
		$image = $this->OpenImage($path, $ext);
		$image = $this->Apply($image, $path);
		if(!$image)
			return;
		if(!is_writable($this->cache_dir))
			@chmod($this->cache_dir, 0777);
		if(is_writable($this->cache_dir))
		{
			$f = @fopen($this->GetCacheFileName($attachment), "w");
			if(!$f)
				return;
			fwrite($f, $this->GetImageOutput($image, $ext));
			fclose($f);
			imagedestroy($image);
		}
	}
	
	function DeleteCacheEntry($attachment)
	{
		$cache_entry = $this->GetCacheFileName($attachment);
		if(file_exists($cache_entry) && is_writable($cache_entry))
			@unlink($cache_entry);
	}
	
	function ClearCache()
	{
		if(!is_writable($this->cache_dir))
		{
			@chmod($this->cache_dir, 0777);
		}
		if(is_writable($this->cache_dir))
		{
			$files = glob($this->cache_dir . "*");
			foreach($files as $file)
			{
				@unlink($file);
			}
		}
	}
	
	function CanWatermark($user)
	{
		$usergroup = usergroup_permissions($user['usergroup']);
		return intval($usergroup['watermark']) || intval($usergroup['cancp']);
	}

}

//LOGIC

$plugins->add_hook("template_attachment_requested", "watermatk_attachment_form");

function watermatk_attachment_form($template)
{
	global $attach_mod_options, $templates, $attachment, $lang, $mybb, $watermark;
	if(!$watermark->CanWatermark($mybb->user))
		return;
	$w = intval($attachment['watermark']);
	if(strpos($attachment['filetype'], "image") !== false)
	{
		if($w == 0)
			eval("\$attach_mod_options .= \"".$templates->get("post_attachments_attachment_mod_watermark")."\";");
		else
			eval("\$attach_mod_options .= \"".$templates->get("post_attachments_attachment_mod_unwatermark")."\";");
	}
}

$plugins->add_hook("editpost_action_start", "watermark_attachment_handler");
$plugins->add_hook("global_start", "watermark_attachment_handler");

function watermark_attachment_handler()
{
	global $mybb, $db, $watermark, $plugins;
	if($plugins->current_hook == "global_start" && THIS_SCRIPT != "newthread.php" && THIS_SCRIPT != "newreply.php")
		return;
	if(!$watermark->CanWatermark($mybb->user))
		return;
	if($mybb->input['attachmentaid'] && isset($mybb->input['attachmentact']) && $mybb->request_method == "post" && ($mybb->input['attachmentact'] == "watermark" || $mybb->input['attachmentact'] == "unwatermark"))
	{
		verify_post_check($mybb->input['my_post_key']);
		$aid = intval($mybb->input['attachmentaid']);
		$attachment = get_attachment($aid);
		if(!$attachment)
			return;
		$watermark->DeleteCacheEntry($attachment);
		if($mybb->input['attachmentact'] == "watermark")
		{
			$watermark->CreateCacheEntry($attachment);
			$attachupdate = array(
				"watermark" => 1,
			);
			$db->update_query("attachments", $attachupdate, "aid='{$attachment['aid']}'");
		}
		elseif($mybb->input['attachmentact'] == "unwatermark")
		{
			$attachupdate = array(
				"watermark" => 0,
			);
			$db->update_query("attachments", $attachupdate, "aid='{$attachment['aid']}'");
		}
		switch(THIS_SCRIPT)
		{
			case "newreply.php":
				$mybb->input['action'] = "newreply";
				break;
			case "newthread.php":
				$mybb->input['action'] = "newthread";
				break;
		}
	}
}

$plugins->add_hook("attachment_end", "watermark_attachment_output");

function watermark_attachment_output()
{
	global $attachment, $mybb, $watermark;
	if(strpos($attachment['filetype'], "image") !== false && !$mybb->input['thumbnail'] && $attachment['watermark'] == 1)
	{
		if(!$watermark->IsCached($attachment))
			$watermark->CreateCacheEntry($attachment);
		$filename = $watermark->GetCacheFileName($attachment);
		if(file_exists($filename) && is_readable($filename))
		{
			$len = filesize($filename);
			header("Content-type: {$attachment['filetype']}");
			header("Content-length: {$len}");
			header("Content-range: bytes=0-".($len-1)."/".$len);
			echo file_get_contents($filename);
			exit;
		}
	}
}

$plugins->add_hook("remove_attachment_do_delete", "watermark_on_remove_attachment");
$plugins->add_hook("remove_attachments_do_delete", "watermark_on_remove_attachment");

function watermark_on_remove_attachment($attachment)
{
	global $watermark;
	if(!is_object($watermark))
		$watermark = new Watermark();
	if($attachment['watermark'] == 1)
		$watermark->DeleteCacheEntry($attachment);
}

//ADMIN PART

$plugins->add_hook("admin_user_groups_edit_graph_tabs", "watermark_admin_group_tab");
$plugins->add_hook("admin_user_groups_edit_graph", "watermark_admin_group_edit");
$plugins->add_hook("admin_user_groups_edit_commit", "watermark_admin_group_edit_commit");

function watermark_admin_group_tab($tabs)
{
	$tabs['watermark'] = "Watermark";
}

function watermark_admin_group_edit_commit()
{
	global $updated_group, $mybb;
	$updated_group['watermark'] = intval($mybb->input['watermark']);
}

function watermark_admin_group_edit()
{
	global $form, $mybb, $form_container, $lang;
	echo "<div id=\"tab_watermark\">";
	$form_container = new FormContainer($lang->watermark_admin_group_tab);
	$options = array($form->generate_check_box("watermark", 1, $lang->watermark_admin_group, array("checked" => $mybb->input['watermark'])));
	$form_container->output_row("Watermark", "", "<div class=\"group_settings_bit\">".implode("</div><div class=\"group_settings_bit\">", $options)."</div>");
	$form_container->end();
	echo "</div>";
}

$plugins->add_hook("admin_config_settings_change", "watermark_on_settings_changed");

function watermark_on_settings_changed()
{
	global $mybb, $watermark;
	if(strcasecmp($mybb->input['upsetting']['watermark_file'], $mybb->settings['watermark_file']) <> 0 && $mybb->request_method == "post")
		$watermark->ClearCache();
}

//GAIN CONTROL OF TEMPLATES OBJECT

if(!defined('IN_ADMIN'))
{

	class myTemplates extends templates
	{

		function __construct($tpl)
		{
			$this->total = $tpl->total;
			$this->cache = $tpl->cache;
			$this->uncached_templates = $tpl->uncached_templates;
		}
	
		function get($title)
		{
			global $plugins;
			$template = parent::get($title);
			if($title == "post_attachments_attachment")
				$template = $plugins->run_hooks("template_attachment_requested", $template);
			return $template;
		}
	
	}
	
	$GLOBALS['templates'] = new myTemplates($GLOBALS['templates']);
	
}

//LANGUAGE VARIABLES

global $lang;

if(file_exists(MYBB_ROOT . "inc/languages/" . $lang->language . "/watermark.lang.php") && $lang->language != "english")
{
	$lang->load("watermark");
}
elseif(!isset($lang->watermark_apply))
{
	$lang->watermark_apply = "اضافة صورة مائية";
	$lang->watermark_not_apply = "الغاء الصورة المائية";
	$lang->watermark_admin_group_tab = "صلاحية الصورة المائية";
	$lang->watermark_admin_group = "يستطيع اضافة صورة مائية لصور المرفقات";
	//ADMIN
	$lang->setting_group_watermark = "هاك الصورة المائية";
	$lang->setting_watermark_file = "الصورة المائية";
	$lang->watermark_file_desc = "Write the path of the image to set as Watermark, the image has to be in PNG or GIF or JPEG format. (If you need to type the ROOT path of MyBB just type __root__ and it will be replaced accordingly)";
}
